<%@page contentType="text/html;charset=utf-8"%>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="ko" xml:lang="ko">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<title>IBSheet7-Product</title>


		<script type="text/javascript" src="../js/common.js"></script>
		<script type="text/javascript" src="../Chart/highcharts/highcharts.js"></script>
		<script type="text/javascript" src="../Chart/ibchart.js"></script>
		<script type="text/javascript" src="../Chart/ibchartinfo.js"></script>

<style type="text/css">
.table_style07 {
	font-family: "Gulim", "Dotum", Arial, Verdana;
	background-color: #E9F3F5;
	font-size: 12px;
	color: #117296;
	text-align: right;
	height: 23px;
	font-weight: 600;
	padding-top: 2px;
}

.table_style09 {
	font-family: "Gulim", "Dotum", Arial, Verdana;
	background-color: #E9F3F5;
	font-size: 12px;
	color: #117296;
	text-align: left;
	height: 23px;
	padding-left: 10px;
	padding-top: 2px;
}

</style>

<script type="text/javascript">
	var pageheightoffset = 250;
	function PageLoad() {
		createIBChart("myChart", "myChart", {
			width: "100%",
			height: "100%"
		});
		ChartDesign();
		fnChartColumnType();
	}

	function ChartDesign() {
		myChart.setOptions({
			chart:{
				type:"column",
				plotBackgroundColor : "#F7FAFB",
				plotBorderColor : "#A9AEB1",
				plotBorderWidth:0.5,

				backgroundColor:{
					linearGradient : [0,0,100,500],
					stops : [
						[0, "#FFFFFF"],
						[1, "#D3D9E5"]
					]
				},
				borderColor : "#84888B"
				//,animation:false
			},
			colors: ["#66ccff", "#0066cc", "#89A54E", "#80699B", "#3D96AE", "#DB843D", "#92A8CD", "#A47D7C", "#B5CA92", "#F7819F"],
			plotOptions:{
				series:{
					dataLabels : {
						enabled:true
					},
					//animation:false,
					colorByPoint : true //시리즈와 무관하게 각 포인트 마다 다른 색상 사용하기
				}
			},
			title:{
				text:"분류별 문화재 현황",
				style:{
					fontWeight:"bold",
					color:"#15498B"
				}
			},
			yAxis:{
				gridLineDashStyle:"solid",
				gridLineColor:"#C4C9CD",
				gridLineWidth:0.5,
				lineColor:"#9BA3A5",
				minorGridLineWidth:0,
				minorTickInterval:25,
				minorTickLength:2,
				minorTickWidth:1,
				minorTickColor:"#7C7C7E",
				tickColor:"#7C7C7E",
				tickInterval:50,
				max:900,
				title:{
					text:""
				}
			},
			xAxis:{
				gridLineWidth:0.5,
				gridLineColor:"#C4C9CD",
				gridLineDashStyle:"solid",
				linecolor:"#9BA3A5",
				minorTickColor:"#7C7C7E",
				tickColor:"#7C7C7E"
			},
			legend:{
				enabled:false
			},
			toolTip:{
				enabled:true,
				formatter:function(){
					return '<span style="color: #4572A7">' + this.series.name + '</span><br/>' + this.point.name + ' : ' + this.y ;
				}
			},
			events: {
				searchEnd: myChart_OnSearchEnd
			}
		});
	}

	function fnChartColumnType(Type) {
		DoSearch(myChart,"./chart01_data.xml");
	}

	function myChart_OnSearchEnd(code, msg) {
		if(!($.browser.msie && parseFloat($.browser.version) < 9)) {
			myChart.setOptions({
				plotOptions:{
					column: {
						borderWidth:1,
						borderRadius:"10px"
					}
				}
			},{
				append: true,
				redraw: true
			});
		}
	}
	function doprint(){
		//차트의 크기를 조정하여 인쇄하기.
		var pop = window.open("","popupPrint","width=500,height=300");
		var div = pop.document.createElement("div");
		div.id = "chart_div";


		//너비,높이가 100% 인 경우 4:3 비율로 자동으로 데이터가 생성됨으로 일시적으로 원하는 크기로 조정한다.
		document.getElementById("myChart").style.width = "500px";
		document.getElementById("myChart").style.height = "300px";

		//기본 인쇄
		myChart.doPrint();

		// var svgData = myChart.GetSVG();
		// div.innerHTML = svgData;
		// pop.document.body.appendChild(div);
		// pop.print();
		// pop.close();

	}
	function down2image(){
		myChart.down2Image({
			fileName:"ChartImage",
			type:"png",
			width:835,
			height:300,
			url:"../Chart/Down2Image.jsp"
		});
	}
	function DoSearch(chart,url,subparam){
		$.ajax({
			type: 'post'
			, async: true
			, dataType:"text"
			, url: url
			, data:  subparam
			, beforeSend: function() {

			  }
			, success: function(xml) {
				chart.loadSearchData(xml,{
					append: true
				});
			  }
			, error: function(data, status, err) {
				alert('서버와의 통신이 실패했습니다.');
			  }
			  ,complete:function(jqXHR,textStatus){

			  }
		});
	}

</script>

<body onload="PageLoad()">

	<div class="page_title">
		<span><a class="closeDepth" href="#">closeDepth</a></span>
		<span class="title color_sheet">차트 조회 > <b>xml 조회</b></span>
	</div>
	<div class="main_content">
		<div style="float:left;width:100%">
			<div class="exp_product" style="float:left;width:30%">
				차트 조회의 데이타구조를 XML로 생성합니다.
			</div>
			
			
			<div class="ib_function" style="float:left;width:70%;text-align:right">
				<a href="javascript:doprint()" class="f1_btn_white gray">인쇄</a>
				<a href="javascript:down2image()" class="f1_btn_white gray">이미지 다운</a>
			</div>
		</div>
		

		<div class="clear hidden"></div>

		<!--div class="ib_function2 border_chart"></div>-->

		<p class="subtit_chart">차트 조회</p>
		<div class="ib_product">
			<div id="myChart"></div>
		</div>
	</div>
</body>
</html>
